/**
** Copyright (C) 2000-2009 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.
**
** This script patches sites to work better with Opera
** For more information see http://www.opera.com/docs/browserjs/
**
** If you have comments on these patches (for example if you are the webmaster
** and want to inform us about a fixed site that no longer needs patching) please
** report issues through the bug tracking system
** https://bugs.opera.com/
**
**/
// Generic fixes (mostly)
(function(opera){				
	// Storing function references
	var postError = opera.postError,
	call = Function.prototype.call,
	indexOf=String.prototype.indexOf,
	lastIndexOf=String.prototype.lastIndexOf,
	replace=String.prototype.replace,
	match=String.prototype.match,
	toLowerCase=String.prototype.toLowerCase,
	getAttribute=Element.prototype.getAttribute,
	setAttribute=Element.prototype.setAttribute,
	insertBefore=Node.prototype.insertBefore,
	insertAdjacentHTML=Element.prototype.insertAdjacentHTML,
	defineMagicVariable=opera.defineMagicVariable,
	defineMagicFunction=opera.defineMagicFunction,
	version=opera.version,
	getElementById=Document.prototype.getElementById,
	appendChild=Node.prototype.appendChild,
	removeChild=Node.prototype.removeChild,
	replaceChild=Node.prototype.replaceChild,
	evaluate=Document.prototype.evaluate,
	getElementsByTagName=Document.prototype.getElementsByTagName,
	createElement=Document.prototype.createElement,
	createTextNode=Document.prototype.createTextNode,
	stopPropagation=Event.prototype.stopPropagation,
	preventDefault=Event.prototype.preventDefault,
	getComputedStyle=window.getComputedStyle,
	slice=Array.prototype.slice,
	shift=Array.prototype.shift,
	setTimeout=window.setTimeout,
	removeAttribute=Element.prototype.removeAttribute,
	addEventListener=Document.prototype.addEventListener,
	isNaN=window.isNaN,
	RegExp=window.RegExp,
	unescape=window.unescape,
	func_toString=Function.prototype.toString,
	parseFloat=window.parseFloat;
	var opera_version = parseFloat.call(window,opera.version());

	// Utility functions
	function addCssToDocument(cssText, doc, mediaType){
		getElementsByTagName.call=addEventListener.call=createElement.call=createTextNode.call=insertBefore.call=setAttribute.call=appendChild.call=version.call=call;
		doc = doc||document;
		mediaType = mediaType||'';
		addCssToDocument.styleObj=addCssToDocument.styleObj||{};
		var styles = addCssToDocument.styleObj[mediaType];
		if(!styles){
			var head = getElementsByTagName.call(doc, "head")[0];
			if( !head ){
				var docEl = getElementsByTagName.call(doc, "html")[0];
				if(!docEl){
					// :S this shouldn't happen - see if document hasn't loaded
					addEventListener.call(doc, opera&&version.call(opera)>=9?'DOMContentLoaded':'load',
					function(){ addCssToDocument(cssText, doc); },false);
					return;
				}
				head = createElement.call(doc, "head");
				if(head) insertBefore.call(docEl, head,docEl.firstChild);
				else head = docEl;
			}
			addCssToDocument.styleObj[mediaType] = styles = createElement.call(doc, "style");
			setAttribute.call(styles, "type","text/css");
			if(mediaType)setAttribute.call(styles, "media", mediaType);
			appendChild.call(styles, createTextNode.call(doc,' '));
			appendChild.call(head, styles)
		}
		styles.firstChild.nodeValue += cssText+"\n";
		return true;
	}

// generic patches

var href = location.href;
var pathname=location.pathname;
if(href == "http://www.google.com.tw/") {
(function(){
    opera.addEventListener('BeforeEventListener.keyup', function(e) {
        if(e.event.target.name=='q') e.preventDefault();
    }, false);
    opera.addEventListener('BeforeEventListener.keydown', function(e) {
        if(e.event.target.name=='q') {e.preventDefault();}
    }, false);
    var setInt=window.setInterval;
    setInterval=function(func,time){
	if( time==10 )time=2000;
	setInt.call(this, func,time);
    };
    })()
}
if(href == "http://www.tw.yahoo.com/") {
(function(){
    opera.addEventListener('BeforeEventListener.keyup', function(e) {
        if(e.event.target.name=='q') e.preventDefault();
    }, false);
    opera.addEventListener('BeforeEventListener.keydown', function(e) {
        if(e.event.target.name=='q') {e.preventDefault();}
    }, false);
    })()
}
if(location.hostname.indexOf('www.google.com')!=-1 && pathname.indexOf('/m')==0) {   
  addCssToDocument('.navbar { height: auto; !important; }');
}

})(opera);
